/* cache Ϊıߴ,ʼ״̬,ռ6,7,10,11Ŀ
cache ˢ¹̷ΪӲ,8,
cacheΪ16С,С:кĩи߶ΪWIN_HEIGHT/2-TILE_HEIGHT/2
	меĸ߶ΪWIN_HEIGHT/2
	WIN_HEIGHT = 11 * TILE_HEIGHT
	WIN_WIDTH = 10 * TILE_WIDTH
	+----+----+----+----+
	|  1 |  2 |  3 |  4 |
    +----+----+----+----+
	|  5 |  6 |  7 |  8 |
    +----+----+----+----+ С !!
	|  9 | 10 | 11 | 12 |
    +----+----+----+----+
	| 13 | 14 | 15 | 16 |
    +----+----+----+----+
*/
#include "..\common.h"
#include "gengine.h"

#define DEBUG

Maze maze[MAZE_SIZE][MAZE_SIZE];

// cache𻭳,ҪʱЧ
Cache cache;

// sceneǽڼʾ
Scene scene;

// ͼ
void MapGenerate( void )
{// for test !
	FILE *fp;
	int i, j;
	char temp[128];

	ZeroMemory( maze, sizeof(maze));
	fp = fopen( "level00.txt", "rb" );
	if( fp == NULL )
		return;
	for( i=0; i<MAZE_SIZE; i++ ){
		fgets( temp, 128, fp );
		for( j=0; j<MAZE_SIZE; j++ )
			if( temp[j] >= 'a' ){ // ground
				maze[i][j].isWall = 0;
				maze[i][j].plot = temp[j] - 'a' + 1;
			}
			else if( temp[j] >= 'A' ){	// wall
				maze[i][j].isWall = 1;
				maze[i][j].occupied = 1;
				maze[i][j].plot = temp[j] - 'A';
			}
	}
	fclose( fp );
	return;
}

void Cache::Redraw( int x, int y, int r, int t, int w, int h )
{//:mazeĵ7λʾ,
	int i, j, k, l, gx;
	int c = MAX( w, (h+1)/2 );
	SpriteSetDrawMode( Bitmap::BetaMode, 256 );

	OutDebugInt( "r", r );
	OutDebugInt( "t", t );
	OutDebugInt( "w", w );
	OutDebugInt( "h", h );

	if( r > c && r < MAZE_SIZE - c
		&& t >= 0 && t < MAZE_SIZE - c*2 ){
		// no clip
		for( i=0; i<h; i++ ){
			l = r + (i+1)/2;
			k = t + i/2;
			gx = (i%2) ? x : x - 32;
			for( j=0; j<w+i%2; j++ ){
				if( maze[k][l].isWall ) // wallbase
					wallBase.Draw( ground, gx, y, maze[k][l].plot  );
				else
					floor.Draw( ground, gx, y, maze[k][l].plot  );
				k ++;
				l --;
				gx -= 64;
			}
			y += 16;
		}
		OutDebugString( "cache.redraw no clip" );
	}
	else{	// clip
		for( i=0; i<h; i++ ){
			l = r + (i+1)/2;
			k = t + i/2;
			gx = (i%2) ? x : x - 32;
			for( j=0; j<w+i%2; j++ ){
				if( k >= 0 && l >= 0 && k < MAZE_SIZE && l < MAZE_SIZE ) 
					if( maze[k][l].isWall ) // wallbase
						wallBase.Draw( ground, gx, y, maze[k][l].plot );
					else
						floor.Draw( ground, gx, y, maze[k][l].plot );
				else
					floor.Draw( ground, gx, y, 0 );
				k ++;
				l --;
				gx -= 64;
			}
			y += 16;
		}
	}
}

void Cache::RefreshTop( void )
{// ػ1,2,3,4
#ifdef DEBUG
	OutDebugString( "refreshTop" );
#endif
	switch( refreshStep ){
	case 0:	// ƶ9,10
		ground->Blit( ground, 0, WIN_HEIGHT*3/2 - TILE_HEIGHT, 
			0, WIN_HEIGHT - TILE_HEIGHT/2, WIN_WIDTH, WIN_HEIGHT/2 );
		break;
	case 1:	// ƶ11,12
		ground->Blit( ground, WIN_WIDTH, WIN_HEIGHT*3/2 - TILE_HEIGHT, 
			WIN_WIDTH, WIN_HEIGHT - TILE_HEIGHT/2, WIN_WIDTH, WIN_HEIGHT/2 );
		break;
	case 2:
		if( sceneX < WIN_WIDTH/2 )	// ƶ4,8
			ground->Blit( ground, WIN_WIDTH*3/2, WIN_HEIGHT/2 - TILE_HEIGHT/2, 
				WIN_WIDTH*3/2, 0, WIN_WIDTH/2, WIN_HEIGHT - TILE_HEIGHT/2 );
		else	// ƶ1,5
			ground->Blit( ground, 0, WIN_HEIGHT/2 - TILE_HEIGHT/2, 
				0, 0, WIN_WIDTH/2, WIN_HEIGHT - TILE_HEIGHT/2 );
		break;
	case 3:
		// have a rest
		break;
	case 4:
		if( sceneX < WIN_WIDTH/2 )	// ƶ1,2,3,5,6,7
			ground->Blit( ground, 0, WIN_HEIGHT/2 - TILE_HEIGHT/2, 0, 0, WIN_WIDTH*3/2, WIN_HEIGHT - TILE_HEIGHT/2 );
		else	// ƶ10,11,12,14,15,16
			ground->Blit( ground, WIN_WIDTH/2, WIN_HEIGHT/2 - TILE_HEIGHT/2, 
				WIN_WIDTH/2, 0, WIN_WIDTH*3/2, WIN_HEIGHT - TILE_HEIGHT/2 );
		sceneY += WIN_HEIGHT/2 - TILE_HEIGHT/2;
		mapX -= WIN_WIDTH/TILE_WIDTH/2; 
		mapY -= WIN_WIDTH/TILE_WIDTH/2;
		break;
	case 5:
		// have a rest
		break;
	case 6:	// 1,2
		Redraw( WIN_WIDTH, 0, mapX-11, mapY-10, WIN_WIDTH/TILE_WIDTH, WIN_HEIGHT/TILE_HEIGHT );
		break;
	case 7:	// 3,4
		Redraw( WIN_WIDTH*2, 0, mapX-1, mapY-20, WIN_WIDTH/TILE_WIDTH, WIN_HEIGHT/TILE_HEIGHT );
		status = NoRefresh;
		break;
	}
	refreshStep ++;
}

void Cache::RefreshTopLeft( void )
{// ػ1,2,3,4,5,9,13
#ifdef DEBUG
	OutDebugString( "RefreshTopLeft" );
#endif
	switch( refreshStep ){
	case 0:	// ƶ9,10,11
		ground->Blit( ground, WIN_WIDTH/2, WIN_HEIGHT*3/2 - TILE_HEIGHT, 0, WIN_HEIGHT - TILE_HEIGHT/2, WIN_WIDTH*3/2, WIN_HEIGHT/2 );
		break;
	case 1:	// ƶ3,7
		ground->Blit( ground, WIN_WIDTH*3/2, WIN_HEIGHT/2 - TILE_HEIGHT/2, WIN_WIDTH, 0, WIN_WIDTH/2, WIN_HEIGHT - TILE_HEIGHT/2 );
		break;
	case 2:	// ƶ1,2,5,6
		ground->Blit( ground, WIN_WIDTH/2, WIN_HEIGHT/2 - TILE_HEIGHT/2, 0, 0, WIN_WIDTH, WIN_HEIGHT - TILE_HEIGHT/2 );
		sceneX += WIN_WIDTH/2;
		sceneY += WIN_HEIGHT/2 - TILE_HEIGHT/2;
		mapX -= WIN_WIDTH/TILE_WIDTH;
		break;
	case 3:
		break;
	case 4:	//1,2
		Redraw( WIN_WIDTH, 0, mapX-11, mapY-10, WIN_WIDTH/TILE_WIDTH, WIN_HEIGHT/TILE_HEIGHT );
		break;
	case 5: // 3,4
		Redraw( WIN_WIDTH*2, 0, mapX-1, mapY-20, WIN_WIDTH/TILE_WIDTH, WIN_HEIGHT/TILE_HEIGHT );
		break;
	case 6:	 // 5,9
		Redraw( WIN_WIDTH/2, WIN_HEIGHT/2 - TILE_HEIGHT/2, mapX-11, mapY, WIN_WIDTH/2/TILE_WIDTH, WIN_HEIGHT/TILE_HEIGHT*2 );
		break;
	case 7:	// 13
		Redraw( WIN_WIDTH/2, WIN_HEIGHT*3/2- TILE_HEIGHT/2, mapX, mapY+11, WIN_WIDTH/2/TILE_WIDTH, WIN_HEIGHT/TILE_HEIGHT );
		status = NoRefresh;
		break;
	}
	refreshStep ++;
}

void Cache::RefreshLeft( void )
{
#ifdef DEBUG
	OutDebugString( "RefreshLeft" );
#endif
	switch( refreshStep ){
	case 0:	// ƶ3,7
		ground->Blit( ground, WIN_WIDTH*3/2, 0, WIN_WIDTH, 0, WIN_WIDTH/2, WIN_HEIGHT - TILE_HEIGHT/2 );
		break;
	case 1:	// ƶ11,15
		ground->Blit( ground, WIN_WIDTH*3/2, WIN_HEIGHT - TILE_HEIGHT/2, WIN_WIDTH, WIN_HEIGHT - TILE_HEIGHT/2, WIN_WIDTH/2, WIN_HEIGHT - TILE_HEIGHT/2 );
		break;
	case 2:
		if( sceneY < WIN_HEIGHT/2 )	// ƶ13,14
			ground->Blit( ground, WIN_WIDTH/2, WIN_HEIGHT*3/2 - TILE_HEIGHT/2, 0, WIN_HEIGHT*3/2 - TILE_HEIGHT/2, WIN_WIDTH, WIN_HEIGHT/2 - TILE_HEIGHT/2 );
		else	// ƶ1,2
			ground->Blit( ground, WIN_WIDTH/2, 0, 0, 0, WIN_WIDTH, WIN_HEIGHT/2 - TILE_HEIGHT/2 );
		break;
	case 3:
		if( sceneY < WIN_HEIGHT/2 )	// ƶ1,2,5,6,9,10
			ground->Blit( ground, WIN_WIDTH/2, 0, 0, 0, WIN_WIDTH, WIN_HEIGHT*3/2 - TILE_HEIGHT/2 );
		else	// ƶ5,6,9,10,13,14
			ground->Blit( ground, WIN_WIDTH/2, WIN_HEIGHT/2 - TILE_HEIGHT/2, 0, WIN_HEIGHT/2 - TILE_HEIGHT/2, WIN_WIDTH, WIN_HEIGHT*3/2 - TILE_HEIGHT/2  );
		sceneX += WIN_WIDTH/2;
		mapX -= WIN_WIDTH/TILE_WIDTH/2;
		mapY += WIN_WIDTH/TILE_WIDTH/2;
		break;
	case 4:
		break;
	case 5:
		break;
	case 6:	//1,5
		Redraw( WIN_WIDTH/2, 0, mapX-16, mapY-5, WIN_WIDTH/TILE_WIDTH/2, WIN_HEIGHT/TILE_HEIGHT*2-1 );
		break;
	case 7:	//9,13
		Redraw( WIN_WIDTH/2, WIN_HEIGHT - TILE_HEIGHT, mapX-6, mapY+5, WIN_WIDTH/TILE_WIDTH, WIN_HEIGHT/TILE_HEIGHT*2+1);
		status = NoRefresh;
		break;
	}
	refreshStep ++;
}

void Cache::RefreshBottomLeft( void )
{
#ifdef DEBUG
	OutDebugString( "RefreshBottomLeft" );
#endif
	switch( refreshStep ){
	case 0:	// ƶ5,6,72,3,4
		ground->Blit( ground, WIN_WIDTH/2, 0, 0, WIN_HEIGHT/2 - TILE_HEIGHT/2, WIN_WIDTH*3/2, WIN_HEIGHT/2 );
		break;
	case 1:	// ƶ11,158,12
		ground->Blit( ground, WIN_WIDTH*3/2, WIN_HEIGHT/2, WIN_WIDTH, WIN_HEIGHT - TILE_HEIGHT/2, WIN_WIDTH/2, WIN_HEIGHT - TILE_HEIGHT/2 );
		break;
	case 2:	// ƶ9,10,13,146,7,10,11
		ground->Blit( ground, WIN_WIDTH/2, WIN_HEIGHT/2, 0, WIN_HEIGHT - TILE_HEIGHT/2, WIN_WIDTH, WIN_HEIGHT - TILE_HEIGHT/2 );
		sceneX += WIN_WIDTH/2;
		sceneY -= WIN_HEIGHT/2 - TILE_HEIGHT/2;
		mapY += WIN_WIDTH/TILE_WIDTH;
		break;
	case 3:
		break;
	case 4:	//9
		Redraw( WIN_WIDTH/2, WIN_HEIGHT - TILE_HEIGHT, mapX-6, mapY+5, WIN_WIDTH/TILE_WIDTH/2, WIN_HEIGHT/TILE_HEIGHT+2 );
		break;
	case 5:	//1,5
		Redraw( WIN_WIDTH/2, 0, mapX-16, mapY-5, WIN_WIDTH/TILE_WIDTH/2, WIN_HEIGHT/TILE_HEIGHT*2-1 );
		break;
	case 6:	//13,14
		Redraw( WIN_WIDTH, WIN_HEIGHT*3/2 - TILE_HEIGHT/2, mapX+5, mapY+6, WIN_WIDTH/TILE_WIDTH, WIN_HEIGHT/TILE_HEIGHT );
		break;
	case 7:	//15,16
		Redraw( WIN_WIDTH*2, WIN_HEIGHT*3/2 - TILE_HEIGHT/2, mapX+15, mapY-4, WIN_WIDTH/TILE_WIDTH, WIN_HEIGHT/TILE_HEIGHT );
		status = NoRefresh;
		break;
	}
	refreshStep ++;
}

void Cache::RefreshBottom( void )
{
#ifdef DEBUG
	OutDebugString( "RefreshBottom" );
#endif
	switch( refreshStep ){
	case 0:	// ƶ5,61,2
		ground->Blit( ground, 0, 0, 0, WIN_HEIGHT/2 - TILE_HEIGHT/2, WIN_WIDTH, WIN_HEIGHT/2 );
		break;
	case 1:	// ƶ7,83,4
		ground->Blit( ground, WIN_WIDTH, 0, WIN_WIDTH, WIN_HEIGHT/2 - TILE_HEIGHT/2, WIN_WIDTH, WIN_HEIGHT/2 );
		break;
	case 2:
		if( sceneX < WIN_WIDTH/2 )	// ƶ12,168,12
			ground->Blit( ground, WIN_WIDTH*3/2, WIN_HEIGHT/2, WIN_WIDTH*3/2, WIN_HEIGHT - TILE_HEIGHT/2, WIN_WIDTH/2, WIN_HEIGHT - TILE_HEIGHT/2 );
		else	// ƶ9,135,9
			ground->Blit( ground, 0, WIN_HEIGHT/2, 0, WIN_HEIGHT - TILE_HEIGHT/2, WIN_WIDTH/2, WIN_HEIGHT - TILE_HEIGHT/2 );
		break;
	case 3:
		if( sceneX < WIN_WIDTH/2 )	// ƶ9,10,11,13,14,155,6,7,9,10,11
			ground->Blit( ground, 0, WIN_HEIGHT/2, 0, WIN_HEIGHT - TILE_HEIGHT/2, WIN_WIDTH*3/2, WIN_HEIGHT - TILE_HEIGHT/2 );
		else	// ƶ10,11,12,14,15,166,7,8,10,11,12
			ground->Blit( ground, WIN_WIDTH/2, WIN_HEIGHT/2, WIN_WIDTH/2, WIN_HEIGHT - TILE_HEIGHT/2, WIN_WIDTH*3/2, WIN_HEIGHT - TILE_HEIGHT/2 );
		sceneY -= WIN_HEIGHT/2 - TILE_HEIGHT/2;
		mapX += WIN_WIDTH/TILE_WIDTH/2;
		mapY += WIN_WIDTH/TILE_WIDTH/2;
		break;
	case 4:
		break;
	case 5:
		break;
	case 6:	//13,14
		Redraw( WIN_WIDTH, WIN_HEIGHT*3/2 - TILE_HEIGHT/2, mapX+5, mapY+6, WIN_WIDTH/TILE_WIDTH, WIN_HEIGHT/TILE_HEIGHT );
		break;
	case 7:	//15,16
		Redraw( WIN_WIDTH*2, WIN_HEIGHT*3/2 - TILE_HEIGHT/2, mapX+15, mapY-4, WIN_WIDTH/TILE_WIDTH, WIN_HEIGHT/TILE_HEIGHT );
		status = NoRefresh;
		break;
	}
	refreshStep ++;
}

void Cache::RefreshBottomRight( void )
{
#ifdef DEBUG
	OutDebugString( "RefreshBottomRight" );
#endif
	switch( refreshStep ){
	case 0:	// ƶ6,7,81,2,3
		ground->Blit( ground, 0, 0, WIN_WIDTH/2, WIN_HEIGHT/2-TILE_HEIGHT/2, WIN_WIDTH*3/2, WIN_HEIGHT/2 );
		break;
	case 1:	// ƶ10,145,9
		ground->Blit( ground, 0, WIN_HEIGHT/2, WIN_WIDTH/2, WIN_HEIGHT-TILE_HEIGHT/2, WIN_WIDTH/2, WIN_HEIGHT-TILE_HEIGHT/2 );
		break;
	case 2:	// ƶ11,12,15,166,7,10,11
		ground->Blit( ground, WIN_WIDTH/2, WIN_HEIGHT/2, WIN_WIDTH, WIN_HEIGHT - TILE_HEIGHT/2, WIN_WIDTH, WIN_HEIGHT - TILE_HEIGHT/2 );
		sceneX -= WIN_WIDTH/2;
		sceneY -= WIN_HEIGHT/2 - TILE_HEIGHT/2;
		mapX += WIN_WIDTH/TILE_WIDTH;
		break;
	case 3:
		break;
	case 4:	//12
		Redraw( WIN_WIDTH*2, WIN_HEIGHT-TILE_HEIGHT, mapX+9, mapY-10, WIN_WIDTH/TILE_WIDTH/2, WIN_HEIGHT/TILE_HEIGHT+2 );
		break;
	case 5:	//4,8
		Redraw( WIN_WIDTH*2, 0, mapX-1, mapY-20, WIN_WIDTH/TILE_WIDTH/2, WIN_HEIGHT/TILE_HEIGHT*2 );
		break;
	case 6:	//13,14
		Redraw( WIN_WIDTH, WIN_HEIGHT*3/2 - TILE_HEIGHT/2, mapX+5, mapY+6, WIN_WIDTH/TILE_WIDTH, WIN_HEIGHT/TILE_HEIGHT );
		break;
	case 7:	//15,16
		Redraw( WIN_WIDTH*2, WIN_HEIGHT*3/2 - TILE_HEIGHT/2, mapX+15, mapY-4, WIN_WIDTH/TILE_WIDTH, WIN_HEIGHT/TILE_HEIGHT );
		status = NoRefresh;
		break;
	}
	refreshStep ++;
}

void Cache::RefreshRight( void )
{
#ifdef DEBUG
	OutDebugString( "RefreshRight" );
#endif
	switch( refreshStep ){
	case 0:	// ƶ2,61,5
		ground->Blit( ground, 0, 0, WIN_WIDTH/2, 0, WIN_WIDTH/2, WIN_HEIGHT - TILE_HEIGHT/2 );
		break;
	case 1:	// ƶ10,149,13
		ground->Blit( ground, 0, WIN_HEIGHT - TILE_HEIGHT/2, WIN_WIDTH/2, WIN_HEIGHT - TILE_HEIGHT/2, WIN_WIDTH/2, WIN_HEIGHT - TILE_HEIGHT/2 );
		break;
	case 2:
		if( sceneY < WIN_HEIGHT/2 - TILE_HEIGHT/2 )	// ƶ15,1614,15
			ground->Blit( ground, WIN_WIDTH/2, WIN_HEIGHT*3/2 - TILE_HEIGHT/2, 
				WIN_WIDTH, WIN_HEIGHT*3/2 - TILE_HEIGHT/2, WIN_WIDTH, WIN_HEIGHT/2 - TILE_HEIGHT/2 );
		else	// ƶ3,42,3
			ground->Blit( ground, WIN_WIDTH/2, 0, 
				WIN_WIDTH, 0, WIN_WIDTH, WIN_HEIGHT/2 - TILE_HEIGHT/2 );
		break;
	case 3:
		if( sceneY < WIN_HEIGHT/2 - TILE_HEIGHT/2 )	// ƶ3,4,7,8,11,122,3,6,7,10,11
			ground->Blit( ground, WIN_WIDTH/2, 0, WIN_WIDTH, 0, WIN_WIDTH, WIN_HEIGHT*3/2 - TILE_HEIGHT/2 );
		else	// ƶ7,8,11,12,15,166,7,10,11,14,15
			ground->Blit( ground, WIN_WIDTH/2, WIN_HEIGHT/2 - TILE_HEIGHT/2, WIN_WIDTH, WIN_HEIGHT/2 - TILE_HEIGHT/2, WIN_WIDTH, WIN_HEIGHT*3/2 - TILE_HEIGHT/2 );
		sceneX -= WIN_WIDTH/2;
		mapX += WIN_WIDTH/TILE_WIDTH/2;
		mapY -= WIN_WIDTH/TILE_WIDTH/2;
		break;
	case 4:
		break;
	case 5:
		break;
	case 6:	//4,8
		Redraw( WIN_WIDTH*2, 0, mapX-1, mapY-20, WIN_WIDTH/TILE_WIDTH/2, WIN_HEIGHT/TILE_HEIGHT*2 );
		break;
	case 7:	//12,16
		Redraw( WIN_WIDTH*2, WIN_HEIGHT - TILE_HEIGHT, mapX+9, mapY-10, WIN_WIDTH/TILE_WIDTH/2, WIN_HEIGHT/TILE_HEIGHT*2+1 );
		status = NoRefresh;
		break;
	}
	refreshStep ++;
}

void Cache::RefreshTopRight( void )
{
#ifdef DEBUG
	OutDebugString( "RefreshTopRight" );
#endif
	switch( refreshStep ){
	case 0:	// ƶ10,11,1213,14,15
		ground->Blit( ground, 0, WIN_HEIGHT*3/2 - TILE_HEIGHT, WIN_WIDTH/2, WIN_HEIGHT - TILE_HEIGHT/2, WIN_WIDTH*3/2, WIN_HEIGHT/2 );
		break;
	case 1:	// ƶ2,65,9
		ground->Blit( ground, 0, WIN_HEIGHT/2 - TILE_HEIGHT/2, WIN_WIDTH/2, 0, WIN_WIDTH/2, WIN_HEIGHT - TILE_HEIGHT/2 );
		break;
	case 2:	// ƶ3,4,7,86,7,10,11
		ground->Blit( ground, WIN_WIDTH/2, WIN_HEIGHT/2 - TILE_HEIGHT/2, WIN_WIDTH, 0, WIN_WIDTH, WIN_HEIGHT - TILE_HEIGHT/2 );
		sceneX -= WIN_WIDTH/2;
		sceneY += WIN_HEIGHT/2 - TILE_HEIGHT/2;
		mapY -= WIN_WIDTH/TILE_WIDTH;
		break;
	case 3:
		break;
	case 4:	//8
		Redraw( WIN_WIDTH*2, WIN_HEIGHT/2 - TILE_HEIGHT/2, mapX+4, mapY-15, WIN_WIDTH/TILE_WIDTH/2, WIN_HEIGHT/TILE_HEIGHT+1 );
		break;
	case 5:	//12,16
		Redraw( WIN_WIDTH*2, WIN_HEIGHT - TILE_HEIGHT, mapX+9, mapY-10, WIN_WIDTH/TILE_WIDTH/2, WIN_HEIGHT/TILE_HEIGHT*2+1 );
		break;
	case 6:	// 1,2
		Redraw( WIN_WIDTH, 0, mapX-11, mapY-10, WIN_WIDTH/TILE_WIDTH, WIN_HEIGHT/TILE_HEIGHT );
		break;
	case 7:	// 3,4
		Redraw( WIN_WIDTH*2, 0, mapX-1, mapY-20, WIN_WIDTH/TILE_WIDTH, WIN_HEIGHT/TILE_HEIGHT );
		status = NoRefresh;
		break;
	}
	refreshStep ++;
}

void Cache::DrawGround( int deltax, int deltay )
{
	if( ABS(deltax) >= WIN_WIDTH/2 || ABS(deltay) >= WIN_HEIGHT/2 )
		;

	sceneX += deltax;
	sceneY += deltay;

	if( status == NoRefresh ){
		// ǷҪˢcache.ground
		if( sceneX <= TILE_WIDTH ){
			if( sceneY <= TILE_HEIGHT * 2 )
				status = InRefreshTopLeft;
			else if( sceneY >= WIN_HEIGHT - TILE_HEIGHT - TILE_HEIGHT * 2 )
				status = InRefreshBottomLeft;
			else 
				status = InRefreshLeft;
		}
		else if( sceneX >= WIN_WIDTH - TILE_WIDTH ){
			if( sceneY <= TILE_HEIGHT * 2 )
				status = InRefreshTopRight;
			else if( sceneY >= WIN_HEIGHT - TILE_HEIGHT - TILE_HEIGHT * 2 )
				status = InRefreshBottomRight;
			else 
				status = InRefreshRight;
		}
		else if( sceneY <= TILE_HEIGHT ){
			if( sceneX <= TILE_WIDTH * 2 )
				status = InRefreshTopLeft;
			else if( sceneX >= WIN_WIDTH - TILE_WIDTH * 2 )
				status = InRefreshTopRight;
			else
				status = InRefreshTop;
		}
		else if( sceneY >= WIN_HEIGHT - TILE_HEIGHT * 2 ){
			if( sceneX <= TILE_WIDTH * 2 )
				status = InRefreshBottomLeft;
			else if( sceneX >= WIN_WIDTH - TILE_WIDTH * 2 )
				status = InRefreshBottomRight;
			else
				status = InRefreshBottom;
		}
		refreshStep = 0;
	}
	if( status != NoRefresh )
		switch( status ){
		case InRefreshTop:
			RefreshTop();
			break;
		case InRefreshTopLeft:
			RefreshTopLeft();
			break;
		case InRefreshLeft:
			RefreshLeft();
			break;
		case InRefreshBottomLeft:
			RefreshBottomLeft();
			break;
		case InRefreshBottom:
			RefreshBottom();
			break;
		case InRefreshBottomRight:
			RefreshBottomRight();
			break;
		case InRefreshRight:
			RefreshRight();
			break;
		case InRefreshTopRight:
			RefreshTopRight();
			break;
		}
	CopyGroundBrightnessMMX( sceneX, sceneY );
}

//mapx, mapy:mapе±
int Cache::InitCache( int level, int mapx, int mapy )
{
	mapX = mapx;
	mapY = mapy;
	// ͼƬ
	if( floor.LoadPicture( level ) != 0 )
		return -1;
	if( wallBase.LoadPicture( level ) != 0 )
		return -1;
	ground = CreateBitmap( WIN_WIDTH*2, WIN_HEIGHT*2 );
	if( ground == NULL ) return -1;

	Redraw( WIN_WIDTH*2, 0, mapx - 1, mapy - 20, WIN_WIDTH/TILE_WIDTH*2, WIN_HEIGHT/TILE_HEIGHT*4 - 2 );

	refreshStep = 0;
	sceneX = WIN_WIDTH/2;
	sceneY = WIN_HEIGHT/2 - TILE_HEIGHT/2;
	return 0;
}


/////////////////////////////////////////////////////////////////////
int Scene::InitScene( int level, int cx, int cy )
{
	MapGenerate( );
	if( cache.InitCache( level, 24, 24 ) != 0 )
		return -1;
	wall.LoadPicture( level );	//ǽڵͼƬ
	centerX = cx;
	centerY = cy;
	x = cx-1;
	y = cy-10;
	moveX = deltaX = 0;
	moveY = deltaY = 0;
	w = 10;
	h = 22+6;
	status = DIR_UNKNOWN;
	refreshStep = 0;

	return 0;
}

void Scene::UpdateStatus( int dir )
{
	if( dir != DIR_UNKNOWN ){
		if( status != DIR_UNKNOWN ){
			if( dir != status )
				FailMsg( "updatescene dir!=status" );
			deltaX -= moveX;
			deltaY -= moveY;
		}
		else{
			refreshStep = 0;
			status = dir;
			switch( dir ){
			case DIR_UP:
				moveX = 0; moveY = -4 ;
				x --; y --; h += 2;
				deltaY = -32;
				deltaY += 4;
				break;
			case DIR_UPLEFT:
				moveX = -4; moveY = -2 ;
				w ++; y --; h ++;
				deltaX = 32; deltaY = -16;
				deltaX += 4; deltaY += 2;
				break;
			case DIR_LEFT:
				moveX = -8; moveY = 0 ;
				w ++;
				deltaX += 8;
				break;
			case DIR_DOWNLEFT:
				moveX = -4; moveY = 2 ;
				w ++; h ++;
				deltaX += 4; deltaY -= 2;
				break;
			case DIR_DOWN:
				moveX = 0; moveY = 4 ;
				h += 2;
				deltaY -= 4;
				break;
			case DIR_DOWNRIGHT:
				moveX = 4; moveY = 2 ;
				x ++; y --; w ++; h ++;
				deltaX = 64;
				deltaX -= 4; deltaY -= 2;
				break;
			case DIR_RIGHT:
				moveX = 8; moveY = 0 ;
				w ++; x ++; y --;
				deltaX = 64;
				deltaX -= 8;
				break;
			case DIR_UPRIGHT:
				moveX = 4; moveY = -2;
				y --; w ++; h ++;
				deltaX = 32; deltaY = -16;
				deltaX -= 4; deltaY += 2;
				break;
			}
		}
		refreshStep ++;
	}
	else{
		moveX = moveY = 0;
	}
}

void Scene::Update( void )
{
	cache.DrawGround( moveX, moveY );
	Draw();
	if( refreshStep == 8 ){
		refreshStep = 0;
		deltaX = deltaY = 0;
		switch( status ){
		case DIR_UP:
			h -= 2;
			centerY --; centerX --;
			break;
		case DIR_UPLEFT:
			x --; y ++; w --; h --;
			centerX --;
			break;
		case DIR_LEFT:
			w --;
			x --; y ++;
			centerY ++; centerX --;
			break;
		case DIR_DOWNLEFT:
			y ++; w --; h --;
			centerY ++;
			break;
		case DIR_DOWN:
			x ++; y ++;
			h -= 2;
			centerY ++; centerX ++;
			break;
		case DIR_DOWNRIGHT:
			y ++; w --; h --;
			centerX ++;
			break;
		case DIR_RIGHT:
			w --;
			centerY --; centerX ++;
			break;
		case DIR_UPRIGHT:
			w --; h --;
			centerY --;
			break;
		}
		status = DIR_UNKNOWN;
	}
}

void Scene::Draw( )
{
	//draw wall and sprites
	backScreen->SetClip( 0, 0, WIN_WIDTH, WIN_HEIGHT );
	int i, j, k, l, gx, gy;
	gy = deltaY;
	for( i=0; i<h; i++ ){
		l = x + (i+1)/2;
		k = y + i/2;
		gx = (i%2) ? WIN_WIDTH+deltaX : WIN_WIDTH+deltaX - 32;
		for( j=0; j<w+i%2; j++ ){
			if( k >= 0 && l >= 0 && k < MAZE_SIZE && l < MAZE_SIZE )
				if( maze[k][l].isWall ){ // wall
					//OutDebugString( "draw wall" );
					wall.Draw( backScreen, gx, gy, maze[k][l].plot );
				}
				else if( maze[k][l].sprite != 0 )
					objects.DrawSprite( maze[k][l].sprite );
			k ++;
			l --;
			gx -= 64;
		}
		gy += 16;
	}
}

void Scene::SetCenter( int cx, int cy )
{
	int dx, dy;
	x = cx - 1;
	y = cy - 10;
	dx = cx - centerX;
	dy = cy - centerY;
	moveX = ( dx - dy ) * TILE_WIDTH/2 - refreshStep * moveX;
	moveY = ( dx + dy ) * TILE_HEIGHT/2 - refreshStep * moveY;
	centerX = cx;
	centerY = cy;
	deltaX = deltaY = 0;
	status = 0;
}

static char off_map[32][64] = {
      { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
      { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
      { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
      { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
      { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
      { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
      { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
      { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
      { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
      { 0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1 },
      { 0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1 },
      { 0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1 },
      { 0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1 },
      { 0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1 },
      { 0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1 },
      { 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2 },
      { 3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,4 },
      { 3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,4,4,4 },
      { 3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,4,4,4,4,4 },
      { 3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,4,4,4,4,4,4,4 },
      { 3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,4,4,4,4,4,4,4,4,4 },
      { 3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,4,4,4,4,4,4,4,4,4,4,4 },
      { 3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4 },
      { 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4 },
      { 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4 },
      { 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4 },
      { 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4 },
      { 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4 },
      { 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4 },
      { 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4 },
      { 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4 },
      { 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4 },
};

void Scene::PixelToPlot( int mx, int my, int *px, int *py )
{
	int tx, ty;
	signed char xoff[5] = { -1,  0, 0, 0, 1};
    signed char yoff[5] = {  0, -1, 0, 1, 0};

	mx = mx + moveX*refreshStep;
	my = my + moveY*refreshStep + TILE_HEIGHT/2;
	tx = mx / TILE_WIDTH;
	ty = my / TILE_HEIGHT;
	*px = tx + ty;
	*py = ty - tx;
	mx &= 63;
	my &= 31;

	*px += xoff[off_map[my][mx]] + centerX - 10;
    *py += yoff[off_map[my][mx]] + centerY - 1;
}



